<?php

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'albumall');
define('CSRF_PROTECTION', true);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('album', 'user');

// get special data templates from the datastore
$specialtemplates = array(
	'smiliecache',
	'bbcodecache'
);

// pre-cache templates
$globaltemplates = array(
	'memberinfo_usercss'
);

// pre-cache templates used by specific actions
$actiontemplates = array(
);

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_album.php');
require_once(DIR . '/includes/functions_user.php');

require_once(DIR . '/includes/class_bootstrap_framework.php');
vB_Bootstrap_Framework::init();
$contenttypeid = vB_Types::instance()->getContentTypeID('vBForum_Album');

// goto a specific page OR search for a word in the picture caption, username or album title
$vbulletin->input->clean_array_gpc('r', array(
	'page' => TYPE_UINT,
	'query' => TYPE_STR
));

$canviewalbums = (
	$vbulletin->options['socnet'] & $vbulletin->bf_misc_socnet['enable_albums']
		AND
	$permissions['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canviewmembers']
		AND
	$permissions['albumpermissions'] & $vbulletin->bf_ugp_albumpermissions['canviewalbum']
);
$canviewgroups = (
	$vbulletin->options['socnet'] & $vbulletin->bf_misc_socnet['enable_groups']
		AND
	$vbulletin->userinfo['permissions']['socialgrouppermissions'] & $vbulletin->bf_ugp_socialgrouppermissions['canviewgroups']
);

if (!$canviewalbums)
{
	if (!$canviewgroups)
	{
		print_no_permission();
	}
}

$userinfo = verify_id('user', $vbulletin->userinfo['userid'], 1, 1, FETCH_USERINFO_USERCSS);

// don't show stuff for users awaiting moderation
if ($userinfo['usergroupid'] == 4 AND !($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']))
{
	print_no_permission();
}


	cache_permissions($userinfo, false);
if (!can_moderate(0, 'caneditalbumpicture') AND !($userinfo['permissions']['albumpermissions'] & $vbulletin->bf_ugp_albumpermissions['canalbum']))
{
	print_no_permission();
}

if (!can_view_profile_section($userinfo['userid'], 'albums'))
{
	standard_error(fetch_error('invalidid', $vbphrase['album'], $vbulletin->options['contactuslink']));
}


// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

	$state=array('public');
	// mods, admins &  super mods can all see picture thumbnails - they may NOT be able to view the actual picture though!)
	if ($userinfo['usergroupid']==5 OR $userinfo['usergroupid']==6 OR $userinfo['usergroupid']==7)
	{
		$state[]='private';
		$state[]='profile';
	}

	$searchquery = $vbulletin->GPC['query'];
	if ($searchquery)
	{
		$searchwhere = "AND (attachment.caption LIKE '%"  . $db->escape_string($searchquery) . "%' OR
							user.username LIKE '%"  . $db->escape_string($searchquery) . "%' OR		
							album.title LIKE '%" . $db->escape_string($searchquery) . "%' OR album.description LIKE '%" . $db->escape_string($searchquery) . "%')";
		$searchquery = htmlspecialchars($searchquery);
	}
	
//get pic count first
	$piccount = $db->query_first("
		SELECT COUNT(*) AS total
		FROM 
			" . TABLE_PREFIX . "attachment as attachment
			LEFT JOIN " . TABLE_PREFIX . "album AS album ON (album.albumid = attachment.contentid)
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (attachment.userid = user.userid)
		WHERE
			(album.userid ='" . $vbulletin->userinfo['userid'] . "'
			OR (album.state IN ('" . implode("', '", $state) . "') AND album.visible > 0))
			AND attachment.contenttypeid = $contenttypeid
			AND attachment.userid=album.userid
			$searchwhere
		");
		
	
	if ($vbulletin->GPC['page'] < 1) $vbulletin->GPC['page'] = 1;

	$perpage = $vbulletin->options['album_pictures_perpage'];
	$total_pages = max(ceil($piccount['total'] / $perpage), 1); // handle the case of 0 pics
	$page = ($vbulletin->GPC['page'] > $total_pages ? $total_pages : $vbulletin->GPC['page']);
	$start = ($page - 1) * $perpage;

	// fetch data and prepare data
	$pictures = $db->query_read("
		SELECT 
			attachment.attachmentid,
			attachment.caption,
			album.albumid,
			IF(filedata.thumbnail_filesize > 0, 1, 0) AS hasthumbnail,
			filedata.thumbnail_width,
			filedata.thumbnail_height,
			album.title,
			attachment.dateline,
			user.username,
			user.userid
		FROM " . TABLE_PREFIX . "attachment AS attachment
		LEFT JOIN " . TABLE_PREFIX . "album AS album ON (album.albumid = attachment.contentid)
		LEFT JOIN " . TABLE_PREFIX . "filedata AS filedata ON (attachment.filedataid = filedata.filedataid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (attachment.userid = user.userid)
		WHERE
			(album.userid ='" . $vbulletin->userinfo['userid'] . "'
			OR (album.state IN ('" . implode("', '", $state) . "') AND album.visible > 0))
			AND attachment.contenttypeid = $contenttypeid
			$searchwhere
		ORDER BY attachment.dateline DESC
		LIMIT $start, $perpage
	");

	$albumbits = '';
	while ($picture = $db->fetch_array($pictures))
	{
		$picture['picturedate'] = vbdate($vbulletin->options['dateformat'], $picture['dateline'], true);

		$picture['caption'] = get_first_line($picture['caption']);
		$picture['title'] = get_first_line($picture['title']);
		
		$picture['coverdimensions'] = ($picture['thumbnail_width'] ? "width=\"$picture[thumbnail_width]\" height=\"$picture[thumbnail_height]\"" : '');

		$templater = vB_Template::create('gallery_picallbit');
			$templater->register('picture', $picture);
			$albumbits .= $templater->render();
	}

	$pagenav = construct_page_nav($page, $perpage, $piccount['total'],
		'picall.php?' . $vbulletin->session->vars['sessionurl_q'] . "query=$searchquery" . ''
	);

	// navbar and final output
	$navbits = construct_navbits(array(
		'picall.php' . $vbulletin->session->vars['sessionurl_q'] . "query=$searchquery"  => 'Gallery' 
		));

	$navbar = render_navbar_template($navbits);

	$custompagetitle = 'Picture Gallery';

	$templater = vB_Template::create('gallery_albumall');
		$templater->register_page_templates();
		$templater->register('albumbits', $albumbits);
		$templater->register('returnscript', 'picall.php');
		$templater->register('custompagetitle', $custompagetitle);
		$templater->register('navbar', $navbar);
		$templater->register('pagenav', $pagenav);
	print_output($templater->render());


function get_first_line($string) // returns first line from string in HTML
{
		if (strlen($string)>25)
		{
			$string = wordwrap(fetch_censored_text($string),25);
			return 	nl2br(substr($string, 0, strpos($string, "\n"))) . ' ...';
		}
		return $string;
}

?>
